/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_rdma_read.c,v 1.16 2005/06/29 00:23:15 eugene Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx_pin.h"

mx_return_t
#ifndef MX_KERNEL
mx_rdma_read(mx_endpoint_t ep, mx_segment_t *segments_list,
	     uint32_t segments_count, mx_endpoint_addr_t target,
	     uint32_t window_handle, uint32_t offset, void *context,
	     mx_request_t *request)
#else
mx_rdma_read(mx_endpoint_t ep, mx_segment_t *segments_list,
	     uint32_t segments_count, mx_pin_type_t pin_type,
	     mx_endpoint_addr_t target,
	     uint32_t window_handle, uint32_t offset, void *context,
	     mx_request_t *request)
#endif
{
#ifndef MX_KERNEL
  mx_pin_type_t pin_type = MX_PIN_UNDEFINED;
#endif

  MX__MUTEX_LOCK(&ep->lock);
  mx_always_assert(0);
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}
